/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.operator;

import am_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import am_libs.org.bouncycastle.operator.ContentSigner;
import am_libs.org.bouncycastle.operator.ExtendedContentSigner;
import am_libs.org.bouncycastle.util.io.BufferingOutputStream;
import java.io.OutputStream;

public class BufferingContentSigner
implements ExtendedContentSigner {
    private final ContentSigner contentSigner;
    private final OutputStream output;

    public BufferingContentSigner(ContentSigner contentSigner) {
        this.contentSigner = contentSigner;
        this.output = new BufferingOutputStream(contentSigner.getOutputStream());
    }

    public BufferingContentSigner(ContentSigner contentSigner, int n) {
        this.contentSigner = contentSigner;
        this.output = new BufferingOutputStream(contentSigner.getOutputStream(), n);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.contentSigner.getAlgorithmIdentifier();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public byte[] getSignature() {
        return this.contentSigner.getSignature();
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        if (this.contentSigner instanceof ExtendedContentSigner) {
            return ((ExtendedContentSigner)this.contentSigner).getDigestAlgorithmIdentifier();
        }
        return null;
    }
}

